$fn = 500;

// paramtre rondelle mtallique
rondelle_d1 = 23.4;
rondelle_d2 = 28.4;
rondelle_ee = 5.2;
rondelle_h = 4.2;

// crou encastr
ecrou_di = 10.2;
ecrou_de = 17;
ecrou_h = 8;

// le bouton lui mme
btn_di = 25;
btn_e = 3;
btn_hi = 12;
btn_h = 31;
btn_accroche_d = 30;
btn_accroche_e = 5;

module tube(di, de, h) {
        difference() {
		cylinder(h = h, d = d_e);
		cylinder(h = h, d = d_i);
	};
}

module rondelle(d1, d2, e_e, h) {
	union() {
		cylinder(h = h, d = d1);
		intersection() {
			cylinder(h = h, d = d2);
			for (r = [0:360/5:359]) {
				rotate([0,0,r]) translate([-e_e / 2, 0, 0]) cube([e_e, d2 / 2, h]);
			};
		};
	};
}

module usin_interne() {
	h_c = btn_di - rondelle_d1;
	union() {
		cylinder(h = btn_hi - h_c, d = btn_di);
		translate([0,0,btn_hi - h_c]) cylinder(h = h_c, d1 = btn_di, d2 = rondelle_d1);
		translate([0,0,btn_hi]) rondelle(d1 = rondelle_d1, d2 = rondelle_d2, e_e = rondelle_ee, h = rondelle_h);
		translate([0,0,btn_hi+rondelle_h]) cylinder(d = ecrou_di, h = ecrou_h);
		translate([0,0,btn_hi+rondelle_h+ecrou_h]) cylinder(d = ecrou_de, h = btn_h - (btn_hi+rondelle_h+ecrou_h));
	};
}

module cylindre_bombe(d, h, e)
{
	h2 = h / 2;
	l = (h2 * h2 - e * e ) / (2 * e);
	translate([0,0,h/2]) rotate_extrude(angle = 360, convexity = 10) {
		intersection() {
			translate([-l + d / 2, 0, 0]) circle(l + e);
			translate([0, -h/2, 0]) square([d/2 + e, h]);
		}; 
	};
}

module accroche(d, de, h, n = 4) {
	for (r = [0:360/n:359]) {
		rotate([0,0,r]) translate([-(de + d) / 2, 0, 0]) cylinder(d = d, h = h);
	};
}


module button() {
	difference() {
		cylindre_bombe(d = (btn_di+btn_e*2), h = btn_h, e = 5);
		accroche(d = btn_di+btn_accroche_e*2, de = btn_di+btn_accroche_e*2, h = btn_h);
		usin_interne();
	};
};

button();

//projection(cut = true) translate([0,0,-10]) rotate([0,0,0]) button();

