
$fn=50;

// fablab printer shrink, adjust to match your own machine/material
shrink=0.19; // = 18.48-18.32

module valve_shape() {
	polygon(points=[
	[0,0], [20.52/2,0],
	[20.52/2,10.59],
	[(22+shrink)/2,10.59],
	[(22+shrink)/2,18.30],
	[(18.48+shrink)/2,18.30],
	[(18.48+shrink)/2,26.40],
	[21.25/2,26.40],
	[21.25/2,39.15],
	[0/2,39.15],
	]);
}

module valve_carve() {
	rotate([90,0,-90]) linear_extrude(height=20) {
		valve_shape();
		mirror([1,0,0]) valve_shape();
	}
}

module valve() {
	rotate_extrude() valve_shape();
	
	translate([0,0,23.40]) {
			rotate([0,0,0]) translate([11-5,-3.25,0]) cube([5+shrink,6.5+shrink,13],false);
			*rotate([0,0,90]) translate([11-5,-3.25,0]) cube([5+shrink,6.5+shrink,13],false);
			rotate([0,0,180]) translate([11-5,-3.25,0]) cube([5+shrink,6.5+shrink,13],false);
			*rotate([0,0,270]) translate([11-5,-3.25,0]) cube([5+shrink,6.5+shrink,13],false);
	}
}

module M3_carve() {
	rotate([0,90,0]) {
		cylinder(d=2.0+shrink, h=40, center=false);
		translate([0,0,-4]) cylinder(d=6, h=4, center=false);
	}
}
module M3() {
	rotate([0,90,0]) {
		cylinder(d=3, h=20, center=false);
		translate([0,0,-4]) difference() { 
			cylinder(d=6, h=4, center=false);
			translate([0,0,-2]) cylinder(d=3/cos(30), h=4, center=false, $fn=6);
		}
	}
}

difference() {
	
	holder_height = 26.40-18.30-1;
	holder_y = (26.40+18.30)/2;
	
	translate([0,0,0]) {
		difference() {
			translate([-2,0,0]) rotate([0,0,90/4]) cylinder(d=32+shrink, h=holder_height, center=true, $fn=8);
			translate([-32,0,0]) cube([50,50,50], true);
			translate([0, 0, -holder_y]) valve_carve();
		}
		
		difference() {
			translate([-24/2,0,0]) cube([9,(32+shrink)*cos(90/4),holder_height], true);
			#translate([-16,0,0]) cube([4,60,60],true);
		}
	}
	
	#translate([0, 0, -holder_y]) valve();
	translate([-18,12,0]) M3_carve();
	translate([-18,-12,0]) M3_carve();
}

%translate([-18,12,0]) M3();
%translate([-18,-12,0]) M3();
