#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Apr 20 13:45:23 2021

@author: Thomas Rodrigues Ruivo
"""

"""
Ce programme ne défini pas de fonctions avec " def() " dans l'espoir d'être plus rapide
Beaucoup de tournures on été prises pour accéléré le programme. 
Note pour les pro : c'est un programme fait par un amateur en 1~2 semaines dans un but précis,
                    ne jugez pas trop svp
Si il y a des erreurs de français dans les commentaires ... je répondrai: ce n'est pas de la littérature et j'ai autre chose à faire avec les partiels et les master ;)
"""

#import de librairies utiles  :  pensez à les istaller au préalable  (insallation facile avec "pip", ex: pip install numpy)
from pathlib import *         #Path() semble avoir été intégré à matplotlib (pathlib serait donc inutile)
from numpy import array,size
from matplotlib import image
import time,csv

start_time=time.time()             #pour estimer le temps d'éxécution du programme

ancien_f=Path('./data_UE665.csv')
a,b=0,0
while b==0 :
    if ancien_f.exists() == True :             #si des fichiers CSV plus anciens existent on ajoute un nombre au nom
        a+=1
        ancien_f=Path('./data_UE665_'+str(a)+'.csv')
    else :
        fichier=ancien_f
        break

#ouverture du fichier en écriture : on ajoute les noms de colonnes
f=open(fichier,'w')
entête=csv.writer(f)
entête.writerow(['image','ratio_total','aire_totale','aire_jaune_cm2','ratio_jaune','aire_grisb_cm2','ratio_grisb','aire_grisrv_cm2','ratio_grisrv','tot_pixel','échelle_pixel'])
f.close()

#on récupère tout les chemins vers les fichiers image (.jpg ; .jpeg ; et si on veux, .png)
p=Path('.')
l=list(p.glob('**/*.jpg'))
l+=list(p.glob('**/*.jpeg'))
#l+=list(p.glob('**/*.png'))   #nos photos sont toutes en JPG 

for q in l :
    tableau = array(image.imread(q))          #JPG
    #tableau = array(Image.open(q))           #PNG
    tab = tableau[:]
    n = size(tab,0)        # taille de la colonne  // nombre de lignes
    p = size(tab,1)        # taille de la ligne  // nombre de colonnes
    pixels=n*p             #sera ajouté au CSV à titre indicatif pour comparer les photos
    y,gb,grv,e=0,0,0,0     #variables de décompte des des pixels (par couleur)
    tablanc=array([[0]*p]*n)   #tableau servant à définir les zones de l'image
    tablanc[0][:]=[1]
    tablanc[n-1][:]=[1]
    tabflot=tab*1.0        # transformation de tab en valeur flotantes (sert à facilité de calcul pour la machine, mérite une vérification de la pertinence)

    #ouverture en ajout de ligne (conservation des données antérieures)
    f=open(fichier,'a')    
    data=csv.writer(f)
    #Note pour le futur : maintenant que j'y pense l'overture pourrait certainement se faire juste avant l'enregistrement des valeurs 
    
    print(q)               #on affiche l'image en cours de traitement (pour avoir un suivis en "direct")
    
    """
    étape 1 : cadrage ---------------------------------------------------------
    4 boucles "for" lisent l'image pour détecter les bords du cadre (en bleu)
    Chaque boucle part d'un côté de l'image 
    (pour une image bien faite les 2 première suffisent)
    Il y a probablement des méthodes plus rapides et de meilleure qualité, 
    mais si le processeur est bon c'est suffisant à notre niveau
    """
    for i in range(0,n):                          #1---------------------------
        for j in range(0,p):                         #lecture de GAUCHE À DROITE
            R= tabflot[i,j][0]
            V= tabflot[i,j][1]
            B= tabflot[i,j][2]
                        
            if V < B and 150 < B and R*1.8<B  :      #si "bleu" reconnu
                tablanc[i,j]=2
                break                                #maintenant on est dans le cadre
            else :
                tablanc[i,j]=1                       #sinon on est encore à lextérieur
    for i in range(0,n):                          #2---------------------------
        for j in range(p-1,-1,-1):                   #lecture de DROITE À GAUCHE
            if tablanc[i,j]== 1:                     #si les boucles antérieures on dit que c'était l'extérieur on passe au pixel suivant
                continue                             #permet d'aller plus vite
            R= tabflot[i,j][0]
            V= tabflot[i,j][1]
            B= tabflot[i,j][2]
            
            if V < B and 150 < B and R*1.8<B  :      #si "bleu" reconnu
                tablanc[i,j]=2
                break                                #maintenant on est dans le cadre
            else :
                tablanc[i,j]=1                       #sinon on est encore à lextérieur
    for j in range(0,p):                          #3---------------------------
        for i in range(0,n):                         #lecture de HAUT EN BAS
            if tablanc[i,j]== 1:                     #si les boucles antérieures on dit que c'était l'extérieur on passe au pixel suivant
                continue                             #permet d'aller plus vite
            R= tabflot[i,j][0]
            V= tabflot[i,j][1]
            B= tabflot[i,j][2]
            
            if V < B and 150 < B and R*1.8<B  :      #si "bleu" reconnu
                tablanc[i,j]=2
                break                                #maintenant on est dans le cadre
            else :
                tablanc[i,j]=1                       #sinon on est encore à lextérieur
    for j in range(0,p):                          #4---------------------------
        for i in range(n-1,-1,-1):                   #lecture de BAS EN HAUT
            if tablanc[i,j]== 1:                     #si les boucles antérieures on dit que c'était l'extérieur on passe au pixel suivant
                continue                             #permet d'aller plus vite
            R= tabflot[i,j][0]
            V= tabflot[i,j][1]
            B= tabflot[i,j][2]
            
            if V < B and 150 < B and R*1.8<B  :      #si "bleu" reconnu
                tablanc[i,j]=2
                break                                #maintenant on est dans le cadre
            else :
                tablanc[i,j]=1                       #sinon on est encore à lextérieur
                
    """
    étape 3 : luminosité globale ----------------------------------------------
    Permet de prendre en compte les paramètres de luminosité spécifique du contexte
    La méthode ne prend en compte que les pixels bleu du cadre,
    car celui-ci est invariant selon l'image.
    """
    lux,nblux=0,0
    for i in range(0,n,2):              #lecture de 4 en 4 pixels (plus rapide)
        for j in range(0,p,2):          #on ne cherche qu'une moyenne de toute façon
            if tablanc[i,j]==0 :        #on le compte pas l'extérieur (plus rapide)
                R= tabflot[i,j][0]
                V= tabflot[i,j][1]
                B= tabflot[i,j][2]
                if V < B and 150 < B and R*1.8<B  :    #si "bleu" reconnu
                    lux+=B                             #somme du bleu de tout les pixels
                    nblux+=1                           # nombre de pixels considérés
                    tablanc[i,j]=2                     #correspond à "cadre" (plus rapide par la suite)
    lum=(lux/nblux)/255                   #moyenne de luminosité en pourcentage
    print('lum='+str(lum))
    delta_lum=0.65/lum                    #on le rapporte à une norme pour laquelle le programme fonctionne bien
    
    """
    étape 2 : couleur ---------------------------------------------------------
    ENFIN, le coeur du programme !
    On va détecté les couleurs selon  plusieurs conditions (l'ordre compte parfois)
    Les lichens nitrophiles on 2 couleurs principales : jaune et gris-bleu (voire gris-vert)
    Mais certaines zones sont très peu saturées (peu de couleur, proche du N&B),
    donc on prend d'autres gris généralement très lumineux (mais parfois un peu moins)
    La méthode de sélection par le code TSV (ou HSV en anglais) c'est avérée la plus éfficace,
    mais aussi la plus lente car les images sont codée de RVB (Rouge, Vert, Bleu)
    il faut donc les traduire en TSV (Teinte, Saturation, Valeur)
    NB: un me lichen à en général une teinte très stable (exeption partie viellisantes et lichens très clairs)
    """
    for i in range(0,n):
        for j in range(0,p):        
            R= tabflot[i,j][0]
            V= tabflot[i,j][1]
            B= tabflot[i,j][2]
            L = max(R,V,B)                      #La "valeur" est la valeur la plus forte de RVB
            if V<B and B> (R*1.35) :            #trop bleu pour être un lichen
                continue                            #on passe (plus rapide)
            v=(L/255)*delta_lum                 #La "valeur" est un pourcentage ; delta_lum sert à normaliser
            if 1<v:
                v=1
            if tablanc[i,j]==2:                 #si on est sur le cadre on ne cherche rien
                continue
            if tablanc[i,j]==1:                 #à l'extérieur on ne cherche que le magenta = échelle
                if V<B :                        #le magenta a peu de vert (plus rapide)
                    _min = min(R, V, B)         #         cacul RVB->HSV
                    delta = L - _min            #         cacul RVB->HSV
                    s = delta / L               #La Saturation     
                    if delta == 0:              #         cacul RVB->HSV
                        delta=255
                    if R == L:
                        h = 60 * (((V - B) / delta) % 6)          #La Teinte si R est max
        
                    else:
                        h = 60 * (((R - V) / delta) + 4)          #La Teinte si B est max
        
                    if 300 < h and 0.3 < v and 0.2<s :            #condition ou se trouve l'échelle
                        if 344<h and 0.5 < (s+v*2)/3 :            #magenta reconnu (echelle)
                            tab[i,j] = [0,255,255]                #on colore en cyan comme témoin
                            e+=1                                  # 1 pixel de plus considéré comme échelle
    
                        if 0.4 < v :
                            if 335 < h <345 and 0.3<s  :              #magenta reconnu (echelle)
                                tab[i,j] = [0,255,255]
                                e+=1
                            elif h<336 and 0.4 < (s+v)/2 <0.725 :     #magenta reconnu (echelle)
                                tab[i,j] = [0,255,255]
                                e+=1
                continue
                   
            #à partir d'ici on n' est ni à l'extérieur ni sur le cadre on est donc à l'intérieur
            _min = min(R, V, B)         #         cacul RVB->HSV
            delta = L - _min            #         cacul RVB->HSV
            s = delta / L               #         cacul RVB->HSV
            if s==0 and 0.4<v :         #si on est en N&B on ne veut pas de couleur trop sombres (ici la teinte sera 0 don on ne se fatigue pas à la calculer)
                tab[i,j] = [0,0,255]    #on colore en bleu comme témoin
                grv+=1                  # 1 pixel de plus considéré comme gris-vert ou gris-rouge
                continue
            if delta == 0:              #         cacul RVB->HSV
                delta=255
            if R == L:
                """ #La condition suivante est trop souvent source d'erreur avec les écorces
                    if 25<h<50 and s<0.08 and 0.55<v :                  #gris-rouge reconnu
                    tab[i,j] = [255,255,0]
                    grv+=1   
                    continue"""
                if s<0.05 and 0.6<v :          #gris-rouge clair reconnu
                    tab[i,j] = [0,0,255]       #témoin bleu
                    grv+=1
                    continue
                h = 60 * (((V - B) / delta) % 6)             #La Teinte si R est max

                
            if L==V :                                        #si le V (vert) est max
                if s<0.1 and 0.6<v :                         #gris-vert reconnu
                    tab[i,j] = [0,0,255]                     #témoin bleu
                    grv+=1   
                elif s<0.4 and 0.5<v and B<V<1.018*R  :      #Jaune verdâtre reconnu
                    tab[i,j] = [0,255,0]                     #témoin vert
                    y+=1
                continue
                

            else :
                h = 60 * (((R - V) / delta) + 4)             #La Teinte si B est max
                
            if 25<h<60 :                                           #limite du Jaune (dominante Rouge)
                if 37 < h < 60  :                                  #pour le jaunes vif
                    if 0.4 < v and 0.1 < s and 0.47<(s+v)/2  :     #jaune reconnu
                        tab[i,j] = [0,255,0]                       #témoin vert
                        y+=1
                    elif 0.08 < s and 0.6 < v  :
                        tab[i,j] = [0,255,0]                       #témoin vert
                        y+=1

                elif 25 < h < 38  and 0.5 < v and 0.7<s  :         #limite des jaunes-orangés
                    tab[i,j] = [0,255,0]                           #témoin vert
                    y+=1
                continue

            if 185<h<210:                                          #limite de bleus cyan (lichens nitrophiles bleutés)
                if h < 205 and s<0.4 and 0.5 < v  :                #gris-cyan reconnu
                    tab[i,j] = [255,0,255]                         #témoin magenta
                    gb+=1
                elif 204 < h and s<0.4 and 0.7 < v  :              #gris-bleu reconnu
                    tab[i,j] = [255,0,255]                         #témoin magenta
                    gb+=1
            if 210<h<300 and s<0.4 and 0.5 < v :                   #gris-bleu plus extrème reconnu
                tab[i,j] = [255,0,255]                             #témoin magenta
                gb+=1
            
            
    if 1000<e :                                 
        surfj=16*y/e ; rj=y/(e*18.75)                            #échelle= 16cm2 et le cadre 300 cm2
        surfgb=16*gb/e ; rgb=gb/(e*18.75)                        #donc le cadre fait 18.75 échelles
        surfgrv=16*grv/e ; rgrv=grv/(e*18.75)
        surf=str(surfj+surfgb+surfgrv) ; r=str((rj+rgb+rgrv)/3)
    else : [surfj,surfgb,surfgrv]=["pas d'échelle"]*3            #si l'échelle est trop petite on considère qu'il n'y a pas d'échelle

    image.imsave(q.stem+'-analysée'+q.suffix,tab)                #on créé une nouvelle image notée "-analysée" sur la quelle on voit les témoins colorés lors de la lecture
    data.writerow([q.name,r,surf,surfj,rj,surfgb,rgb,surfgrv,rgrv,str(pixels),e])    #on entre nos données dans le fichier CSV
    print(str(surf)+' cm2')                                      #affiche la surface pour avoir un suivis en "direct"
    f.close()                                                    #on ferme le fichier
    
end_time=time.time()                         #calcul du temps total d'éxécution
tms=(end_time-start_time)
tmm=tms/60                                   #en minutes
print(str(size(l))+' images traitées')       #et dit combien d'images il a traité dans ce temps
print('temps écoulé: '+str(tmm)+' min')