/*
  ReadAnalogVoltage
  Reads an analog input on pin 0, converts it to voltage, and prints the result to the serial monitor.
  Graphical representation is available using serial plotter (Tools > Serial Plotter menu)
  Attach the center pin of a potentiometer to pin A0, and the outside pins to +5V and ground.

  This example code is in the public domain.
*/

float v0, v1, v2, v3, v4;
unsigned long int temps;
// the setup routine runs once when you press reset:
void setup() {
  // initialize serial communication at 9600 bits per second:
  Serial.begin(9600);
}

// the loop routine runs over and over again forever:
void loop() {
  // read the input on analog pin 0:
  int sensorValue = analogRead(A0);
  // Convert the analog reading (which goes from 0 - 1023) to a voltage (0 - 5V):
  v0 = sensorValue * (5.0 / 1023.0);
  sensorValue = analogRead(A1);
  v1 = sensorValue * (5.0 / 1023.0);
  sensorValue = analogRead(A2);
  v2 = sensorValue * (5.0 / 1023.0);
  sensorValue = analogRead(A3);
  v3 = sensorValue * (5.0 / 1023.0); 
   sensorValue = analogRead(A4);
  v4 = sensorValue * (5.0 / 1023.0); 
  temps = millis();
  Serial.print(temps);
  Serial.print(" ");
  Serial.print(v0);
  Serial.print(" ");
  Serial.print(v1);
  Serial.print(" ");
  Serial.print(v2);
  Serial.print(" ");
  Serial.print(v3);
  Serial.print(" ");
  Serial.println(v4);
//  delay(10);
}
