#define OUT 0

char seq[8] = "message";
int T = 2;

int mySize(unsigned int a) {
  int s = 0;

  if (a > 0) s++;
  
  while ( (a = a >> 1) > 0) {
    s++; 
  }

  return s;
}

void setup() {
  Serial.begin(9600);
  pinMode(OUT, OUTPUT);
}

void changeOut() {
  static bool out = true;
  if (out) {
    digitalWrite(OUT, HIGH);
  } else {
    digitalWrite(OUT, LOW);
  }
  out = !out;
}

void flag() {
  for (int i = 0; i < 5; i++) {
    delay(T/2);
    changeOut();
    delay(T/2);
    changeOut();
  }
}

void loop() {
  int nb_ones = 0;
  char reversed;

  flag();

  // For the number of characters
  for(int i = 0; i < sizeof(seq) - 1; i++) {
    
    // For each bit of each byte
    for(int j = 7; j >= 0; j--){
      delay(T/2);
      changeOut();
      delay(T/2);
      
      if ((seq[i] >> j) & 1) {
        nb_ones++;
        changeOut();
      } else {
        nb_ones = 0;
      }

      // Adding a zero to the sequence such that it doesn't look like the flag
      if (nb_ones == 4) {
        delay(T/2);
        changeOut();
        delay(T/2);
        nb_ones = 0;
      }
      
    }
  }

  flag();
}
