// Utiliser une version 2.8.0 ou inferieure de la bibliotheque IRremote 
// (Ici , le code fonctionne avec la version 2.7.0 ) 

#include <IRremote.h> //include the library
#include <Servo.h>

//#include <LiquidCrystal.h> // includes the LiquidCrystal Library 
//LiquidCrystal lcd(12, 11, 5, 4, 3, 2  ); // Creates an LC object. Parameters: (rs, enable, d4, d5, d6, d7) 

//FF6897 : 1

//FF9867 : 2

//FFB04F : 3

//FF30CF : 4

//FF18E7 : 5

//FF7A85 : 6

//FF10EF : 7

//FF38C7 : 8

//FF5AA5 : 9

//FF4AB5 : 0
//FF42BD : *

//FF52AD : #


// Aileron 
#define Button_1 0xFF6897 // (Position haute , rotation à droite)
#define Button_2 0xFF9867 // (Position Initiale)
// Volet
#define Button_4 0xFF30CF // + 20 deg 
#define Button_5 0xFF18E7 // + 40 Deg 
#define Button_6 0xFF7A85 // + 65 deg 
#define Button_0 0xFF4AB5  // 0 deg 

int receiver = 13; //initialize pin 13 as recevier pin.
uint32_t Previous; 
IRrecv irrecv(receiver); //create a new instance of receiver
decode_results results;

Servo aileron_droit;
Servo aileron_gauche;
Servo volet_droit;
Servo volet_gauche;




void setup() {
 Serial.begin(9600);
 irrecv.enableIRIn(); //start the receiver

//  // Initialisation 
 aileron_droit.attach(9);
  aileron_gauche.attach(10);
  
  volet_droit.attach(5);
  volet_gauche.attach(6);
  
  
  
  aileron_droit.write(90);
  aileron_gauche.write(90);

  volet_droit.write(90);
  volet_gauche.write(90);

         
       // lcd.print("Flaps 0 deg"); 

}


void loop() {



 
 if (irrecv.decode(&results)) { //if we have received an IR signal
 if (results.value==0xFFFFFFFF) { 
      results.value=Previous;
      }

    switch(results.value) {
           
           // Les servos moteurs du volet (ou  de l'aileron) étant l'un face à l'autre , on ne peut leur donner la meme consigne d'angle (car symétrie)
           // On les initialise donc à 90 degrés et lors d'un appui boutton , l'un de servos continue sa rotation dans le sens trigonométrique tandis que 
           // l'autre tourne dans le sens horraire avec la meme quantité "angulaire". Tout cela nous permet d'assurer le bon fonctionnement et la 
           // bonne roration pour nos mécanismes 
           
           
           // Aileron 
        case Button_1 :        
       aileron_droit.write(150); // Position haute de l'aileron (rotation à droite) , rotation de roulis (à droite)
       aileron_gauche.write(30); 
  
       break;
           
           
       case Button_2 :        
       aileron_droit.write(90); // Position de réference  
       aileron_gauche.write(90); 
    
       break;
             
             
            


       // Volet
       
       case Button_4 :        
       volet_droit.write(100); // 10 degrés
       volet_gauche.write(80); 
//        lcd.clear() ; 
//       lcd.print("Flaps 10 deg"); 
       break;
       
       
       case Button_5 :        
       volet_droit.write(120); // 30 degrés
       volet_gauche.write(60); 
//         lcd.clear() ; 
//       lcd.print("Flaps 30 deg"); 
       break;

       case Button_6 :        
       volet_droit.write(140); // 60 degrés 
       volet_gauche.write(40); 
//         lcd.clear() ; 
//       lcd.print("Flaps 50 deg"); 
       break;


       case Button_0 :        // Position de réference 
       volet_droit.write(90); 
       volet_gauche.write(90); 
//       lcd.clear() ; 
//       lcd.print("Flaps 0 deg"); 
       break;
      
      
      
      } 
 Serial.println (results.value, HEX); //display HEX results 
 irrecv.resume(); //next value
 }
 Previous=results.value;
 }
