//  _ ___ _______     ___ ___ ___  ___ _   _ ___ _____ ___ 
// / |_  )__ /   \   / __|_ _| _ \/ __| | | |_ _|_   _/ __| 
// | |/ / |_ \ |) | | (__ | ||   / (__| |_| || |  | | \__ \ 
// |_/___|___/___/   \___|___|_|_\\___|\___/|___| |_| |___/ 
// 
// KeyPad + LCD16X2
// 
// Made by Hessel Timothee
// License: CC-BY-SA 3.0
// Downloaded from: https://circuits.io/circuits/4242774-keypad-lcd16x2

#include <LiquidCrystal.h>
#include <Keypad.h>

const byte rows = 4; //four rows
const byte cols = 3; //four columns

byte rowPins[rows] = {7, 6, 5, 4};
byte colPins[cols] = {3, 2, 1};

int keys[rows][cols] = {
  {1, 2, 3},
  {4, 5, 6},
  {7, 8, 9},
  {10, 0, 1}
};


LiquidCrystal lcd(8, 9, 10, 11, 12, 13);

Keypad keypad = Keypad(makeKeymap(keys), rowPins, colPins, rows, cols);

int menu;
int tempcible = 20;
int humcible = 30;
int allcible = 7;
int extcible = 20;

int enter(){

  int a;
  int b;
  int val;
  
  a = keypad.waitForKey();
  b = keypad.waitForKey();
  
  val = 10 * a + b;
  lcd.setCursor(12,1);
  lcd.print(val);
  return (val);
}

void setup(){
  
  lcd.begin(16,2);
  lcd.setCursor(0,0);
  lcd.print("Choisir un menu");
  Serial.begin(9600);
}

void param(int menu){
 
  if (menu == 1)
  {
  tempcible = enter();
  lcd.setCursor(14,1);
  lcd.write(176);
  lcd.setCursor(15,1);
  lcd.print("C");
  }
  if (menu == 2)
  {
  humcible = enter();
  lcd.setCursor(14,1);
  lcd.print("%");
  }
  if (menu == 3)
  {
  allcible = enter();
  lcd.setCursor(14,1);
  lcd.print("h");
  }
  if (menu == 4)
  {
  extcible = enter();
  lcd.setCursor(14,1);
  lcd.print("h");
  }
}

void loop(){
  int key = keypad.getKey();
    if (menu==0)
    {
        if (key==1)
        {
        lcd.clear();
        menu=1;
        lcd.setCursor(0,0);
        lcd.print("Temperature");
        lcd.setCursor(12,1);
        lcd.print(tempcible);
        lcd.setCursor(14,1);
        lcd.write(176);
        lcd.setCursor(15,1);
        lcd.print("C");
      	}
        if (key==2)
        {
        lcd.clear();
        menu=2;
        lcd.setCursor(0,0);
        lcd.print("Humidite");
        lcd.setCursor(12,1);
        lcd.print(humcible);
        lcd.setCursor(14,1);
        lcd.print("%");
        }
		if (key==3)
        {
        lcd.clear();
        menu=3;
        lcd.setCursor(0,0);
        lcd.print("Allumage");
        lcd.setCursor(12,1);
        lcd.print(allcible);
        lcd.setCursor(14,1);
        lcd.print("h");
        }
        if (key==4)
        {
        lcd.clear();
        menu=4;
        lcd.setCursor(0,0);
        lcd.print("Extinction");
		lcd.setCursor(12,1);
        lcd.print(extcible);
        lcd.setCursor(14,1);
        lcd.print("h");
        }
    }
    if (key==10)
      param(menu);
    if (key==11){
      setup();
      menu=0;
    }
}
