#include <DHT.h>
#include <DHT_U.h>
#define DHTPIN 2     // what pin we're connected to
#define DHTTYPE DHT22   // DHT 22  (AM2302)
DHT dht(DHTPIN, DHTTYPE);


//Valeurs déclaratives concernant la partie en contact avec l'air humidifié
float temp_voulue = 24 ;
int module_peltier_chaud_air = 3 ;
int module_peltier_froid_air = 4 ;
float erreur_temp = 0;
float somme_erreur_temp = 0;
float variation_erreur_temp = 0;
//kp_temp,ki_temp et kd_temp sont des coeficient utilisé dans la fonction PID pour contrôler la chauffe du peltier en contact avec l'air humidifié
float Kp_temp = 0.25;
float Ki_temp = 0.25;
float Kd_temp = 0.25;
float erreur_temp_precedente = erreur_temp;
int coeficient_temp = 0;
int avant_temp = 0;


// Valeurs déclarative concernant la partie en contact avec le bol d'eau
float humidite_voulue = 0.8;
int module_peltier_chaud_eau = 5;
int module_peltier_froid_eau = 6;
float erreur_humidite = 0;
float somme_erreur_humidite = 0;
float variation_erreur_humidite = 0;
//kp_humidite, ki_humidite et kd_humidite sont des coeficient utilisé dans la fonction PID pour contrôler la chauffe du peltier du bol d'eau
float Kp_humidite = 1;
float Ki_humidite = 0.25;
float Kd_humidite = 1;
float erreur_humidite_precedente = erreur_humidite;
int coeficient_humidite = 0;
int avant_humidite = 0;

// Fonction setup(), appelées au démarrage de la carte Arduino
void setup() {

  // Initialise la communication avec le PC
  Serial.begin(9600);
  dht.begin();
  //On déclare les branchements des modules peltiers comme sorti de l'arduino
  //Ces sorties contrôleront le double pont en H ce qui alimentera ou non le peltier pour qu'il chauffe ou qu'il refroidisse
  pinMode(module_peltier_chaud_air, OUTPUT);
  pinMode(module_peltier_froid_air, OUTPUT);
  pinMode(module_peltier_chaud_eau, OUTPUT);
  pinMode(module_peltier_froid_eau, OUTPUT);
}

// Fonction loop(), appelées continuellement en boucle tant que la carte Arduino est alimentée
void loop() {

  delay(2000);
  //La lecture de la température ou de l'humidite peut prendre jusqu'à 250 millisecondes


  //Integre dans les variables humidite_mes et temp_mes les données issues du capteur
  int humidite_mes = dht.readHumidity();
  float temp_mes = dht.readTemperature();



  // Vérifie si la lecture de la température et de l'humidite est bien effectuée
  if (isnan(humidite_mes) || isnan(temp_mes)) {
    Serial.println("Failed to read from DHT sensor!");
    return;
  }

  //Affiche  dans le moniteur l'humidite et la temperature
  Serial.print("Température: ");
  Serial.print(temp_mes);
  Serial.print(" *C ");
  Serial.print("humidite: ");
  Serial.print(humidite_mes);
  Serial.println(" %\t");


  //Fonctionnement du PID, cette boucle fait varier la tension de A0 en fonction
  //de l'allure de la courbe de temp_mes et en fonction de l'écart entre la valeur
  //de temp_mes et temp_voulue, vous pouvez vous renseigner sur l'utilité d'une fonction PID sur internet

  erreur_temp = temp_voulue - temp_mes;


  //Verifie la température mesurée par rapport à la température désirée
  if (temp_mes < temp_voulue) {
    
    //Converti la valeur du PID pour donner une valeur de "coeficient_temp" entre 0 et 255, grâce à cela nous pourront 
    //utiliser la fonction PWM pour contrôler avec le pont en H le courant distribué à chaque module. 
    
    if (avant_temp == 1) somme_erreur_temp = 0;
    coeficient_temp =  (Kp_temp * erreur_temp + Ki_temp * somme_erreur_temp + Kd_temp * variation_erreur_temp) / 15 * 255;
    if (coeficient_temp > 255) {
      coeficient_temp = 255;
    }


    analogWrite (module_peltier_chaud_air , coeficient_temp);
    digitalWrite (module_peltier_froid_air , LOW);
    avant_temp = 0;

  }
  else {
    erreur_temp = -erreur_temp;
    if (avant_temp == 0) somme_erreur_temp = 0;
    coeficient_temp =  (Kp_temp * erreur_temp + Ki_temp * somme_erreur_temp + Kd_temp * variation_erreur_temp) / 15 * 255;
    if (coeficient_temp > 255) {
      coeficient_temp = 255;
    }

    analogWrite (module_peltier_froid_air , coeficient_temp);
    digitalWrite (module_peltier_chaud_air , LOW);
    avant_temp = 1;
  }


  somme_erreur_temp = somme_erreur_temp + erreur_temp;
  variation_erreur_temp = erreur_temp - erreur_temp_precedente;
  erreur_temp_precedente = erreur_temp;




  //Fonctionnement du PID, cette boucle fait varier la tension de A1 en fonction
  //de l'allure de la courbe de humidite_mes et en fonction de l'écart entre la valeur
  //de humidite_mes et humidite_voulue, vous pouvez vous renseigner sur l'utilité d'une fonction PID sur internet


  erreur_humidite = humidite_voulue - humidite_mes;


  //Nous utilisons la fonction PWM de l'arduino, avec un transistor pour controler l'intensité de courant fournie au module peltier sous le bloc d'eau.
  //Le PWM permet à l'arduino de simuler un signal analogique avec un signal carré entre 0 et 5V.



  //Verifie l'humiditée mesurée par rapport à l'humiditée désirée
  if (humidite_mes < humidite_voulue) {

    //Converti la valeur du PID pour donner une valeur de "coeficient_temp" entre 0 et 255, grâce à cela nous pourront 
    //utiliser la fonction PWM pour contrôler avec le pont en H le courant distribué à chaque module. 
    
    if (avant_humidite == 1) somme_erreur_humidite = 0;
    coeficient_humidite =  (Kp_humidite * erreur_humidite + Ki_humidite * somme_erreur_humidite + Kd_humidite * variation_erreur_humidite) / 15 * 255;
    if (coeficient_humidite > 255) {
      coeficient_humidite = 255;
    }


    analogWrite (module_peltier_chaud_air , coeficient_humidite);
    digitalWrite (module_peltier_froid_air , LOW);
    avant_humidite = 0;

  }
  else {
    erreur_humidite = -erreur_humidite;
    if (avant_humidite == 0) somme_erreur_humidite = 0;
    coeficient_humidite =  (Kp_humidite * erreur_humidite + Ki_humidite * somme_erreur_humidite + Kd_humidite * variation_erreur_humidite) / 15 * 255;
    if (coeficient_humidite > 255) {
      coeficient_humidite = 255;
    }

    analogWrite (module_peltier_froid_air , coeficient_humidite);
    digitalWrite (module_peltier_chaud_air , LOW);
    avant_humidite = 1;
  }


  float somme_erreur_humidite = somme_erreur_humidite + erreur_humidite;
  float variation_erreur_humidite = erreur_humidite - erreur_humidite_precedente;
  float erreur_humidite_precedente = erreur_humidite;


Serial.print("pwm temperature : ");
Serial.print(coeficient_temp);
Serial.print("    pwm humidite : ");
Serial.println(coeficient_humidite);
Serial.println();
}


