#include <DHT.h>
#include <DHT_U.h>
#define DHTPIN 2     // what pin we're connected to
#define DHTTYPE DHT22   // DHT 22  (AM2302)
DHT dht(DHTPIN, DHTTYPE);

int humidite_mes;
float temp_mes;
int frequence_echantillonnage = 3; // en seconde

//Valeurs dÃ©claratives concernant la partie en contact avec l'air humidifiÃ©
float temp_voulue = 24 ;
int module_peltier_chaud_air = 3 ;
int module_peltier_froid_air = 4 ;

//kp_temp,ki_temp et kd_temp sont des coeficient utilisÃ© dans la fonction PID pour contrÃ´ler la chauffe du peltier en contact avec l'air humidifiÃ©
float Kp_temp = 1;
float Ki_temp = 1;
float Kd_temp = 5;
float ecart_temp;
float ecart_temp_preced;
int coeficient_temp;
float integral_temp;
float derivee_temp;


// Valeurs dÃ©clarative concernant la partie en contact avec le bol d'eau
float humidite_voulue = 80;
int module_peltier_chaud_eau = 5;
int module_peltier_froid_eau = 6;

//kp_humidite, ki_humidite et kd_humidite sont des coeficient utilisÃ© dans la fonction PID pour contrÃ´ler la chauffe du peltier du bol d'eau
float Kp_humidite = 0.1;
float Ki_humidite = 1;
float Kd_humidite = 5;
float ecart_humidite;
float ecart_humidite_preced;
int coeficient_humidite;
float integral_humidite;
float derivee_humidite;


// Fonction setup(), appelÃ©es au dÃ©marrage de la carte Arduino
void setup() {

  // Initialise la communication avec le PC
  Serial.begin(9600);
  dht.begin();
  //On dÃ©clare les branchements des modules peltiers comme sorti de l'arduino
  //Ces sorties contrÃ´leront le double pont en H ce qui alimentera ou non le peltier pour qu'il chauffe ou qu'il refroidisse
  pinMode(module_peltier_chaud_air, OUTPUT);
  pinMode(module_peltier_froid_air, OUTPUT);
  pinMode(module_peltier_chaud_eau, OUTPUT);
  pinMode(module_peltier_froid_eau, OUTPUT);
}

// Fonction loop(), appelÃ©es continuellement en boucle tant que la carte Arduino est alimentÃ©e
void loop() {

  delay(frequence_echantillonnage*1000);
  //La lecture de la tempÃ©rature ou de l'humidite peut prendre jusqu'Ã  250 millisecondes


  //Integre dans les variables humidite_mes et temp_mes les donnÃ©es issues du capteur
  humidite_mes = dht.readHumidity();
  temp_mes = dht.readTemperature();



  // VÃ©rifie si la lecture de la tempÃ©rature et de l'humidite est bien effectuÃ©e
  if (isnan(humidite_mes) || isnan(temp_mes)) {
    Serial.println("Failed to read from DHT sensor!");
    return;
  }

  //Affiche  dans le moniteur l'humidite et la temperature
  Serial.print("TempÃ©rature: ");
  Serial.print(temp_mes);
  Serial.print(" *C ");
  Serial.print("humidite: ");
  Serial.print(humidite_mes);
  Serial.println(" %\t");

  //Fonctionnement du PID, pour en savoir plus pour le PID : https://en.wikipedia.org/wiki/PID_controller
  ecart_temp = temp_voulue - temp_mes;
  integral_temp = integral_temp + ecart_temp * frequence_echantillonage;
  derivee_temp = (ecart_temp - ecart_temp_preced) / frequence_echantillonage;
  coeficient_temp = (Kp_temp * ecart_temp + Ki_temp * integral_temp + Kd_temp * derivee_temp)/10* 255;
  if (coeficient_temp > 255 ) coeficient_temp = 255; // coeficient_temp va être une sortie "pseudo-analogique", PWM. Le rapport cyclique du PWM prend des valeursde 0 à 100%  en 10 bits sela donne donc de 0 a 255
  ecart_temp_preced = ecart_temp;


  //Verifie la tempÃ©rature mesurÃ©e par rapport Ã  la tempÃ©rature dÃ©sirÃ©e
  if (ecart_temp >0) {
    analogWrite (module_peltier_chaud_air , coeficient_temp);// utilisation du PWM pour controler les modules Peltier avec le pont en H
    digitalWrite (module_peltier_froid_air , LOW);
  }
  else {
    digitalWrite (module_peltier_chaud_air , LOW);
    analogWrite (module_peltier_froid_air , coeficient_temp);// utilisation du PWM pour controler les modules Peltier avec le pont en H
  }



  //Fonctionnement du PID, pour en savoir plus pour le PID : https://en.wikipedia.org/wiki/PID_controller
  ecart_humidite = humidite_voulue - humidite_mes;
  integral_humidite = integral_humidite + ecart_humidite * frequence_echantillonage;
  derivee_humidite = (ecart_humidite - ecart_humidite_preced) / frequence_echantillonage;
  coeficient_humidite = (Kp_humidite * ecart_humidite + Ki_humidite * integral_humidite + Kd_humidite * derivee_humidite)/500 * 255;
  if (coeficient_humidite > 255 ) coeficient_humidite = 255 ;// coeficient_humidite va être une sortie "pseudo-analogique", PWM. Le rapport cyclique du PWM prend des valeursde 0 à 100%  en 10 bits sela donne donc de 0 a 255
  ecart_humidite_preced = ecart_humidite;


  //Verifie l'humiditÃ©e mesurÃ©e par rapport Ã  l'humiditÃ©e dÃ©sirÃ©e
  if (ecart_humidite > 0) {
    analogWrite (module_peltier_chaud_eau , coeficient_humidite); // utilisation du PWM pour controler les modules Peltier avec le pont en H
    digitalWrite (module_peltier_froid_eau , LOW);

  }
  else {
    analogWrite (module_peltier_froid_eau , coeficient_humidite);// utilisation du PWM pour controler les modules Peltier avec le pont en H
    digitalWrite (module_peltier_chaud_eau , LOW);
  }


  Serial.print("pwm temprature : ");
  Serial.print(coeficient_temp);
  Serial.print("    pwm humidite : ");
  Serial.println(coeficient_humidite);
  Serial.println();
}

