#include <DHT.h>

int temp_voulue = 24 ;
int delta_temp = 10 ;
int pont_thermique_chaud = 3 ;
int pont_thermique_froid = 4 ;
int temps_pause = 1 ; // TEMPS DE PAUSE EN MINUTE
int erreur = 0;
int somme_erreur = 0;
int variation_erreur = 0;
int Kp = 1;
int Ki = 0.25;
int Kd = 1;
int erreur_precedente = erreur;

// Fonction setup(), appelée au démarrage de la carte Arduino
void setup() {

  // Initialise la communication avec le PC
  Serial.begin(9600);
  pinMode(pont_thermique_chaud, OUTPUT);
  pinMode(pont_thermique_froid, OUTPUT);

}

// Fonction loop(), appelée continuellement en boucle tant que la carte Arduino est alimentée
void loop() {
mesure:
  // Mesure la tension sur la broche A0
  int valeur_brute = analogRead(A0);

  // Transforme la mesure (nombre entier) en température via un produit en croix
  float temp_mes = valeur_brute * (5.0 / 1023.0 * 100.0);

  // Envoi la mesure au PC pour affichage et attends 250ms
  Serial.println(temp_mes);
  delay(250);
  if (temp_mes < temp_voulue)
  {
    digitalWrite (pont_thermique_chaud , HIGH);
    digitalWrite (pont_thermique_froid , LOW);
  }
  else
  {
    digitalWrite (pont_thermique_froid , HIGH);
    digitalWrite (pont_thermique_chaud , LOW);
  }




  //Fonctionnement du PID, cette boucle fait varier la tension de A1 en fonction de l'allure de la courbe de temp_mes et en fonction de l'écart entre la valeur de temp_mes et temp_voulue

  erreur = temp_voulue - temp_mes;
  analogWrite(A1, Kp * erreur + Ki * somme_erreur + Kd * variation_erreur); //la tension en A1 varie selon une commande PID
  somme_erreur = somme_erreur + erreur;
  variation_erreur = erreur - erreur_precedente;
  erreur_precedente = erreur;
}
