#include <Adafruit_NeoPixel.h>

// Which pin on the Arduino is connected to the NeoPixels?
// On a Trinket or Gemma we suggest changing this to 1
#define PIN            6

// How many NeoPixels are attached to the Arduino?
#define NUMPIXELS      16

// When we setup the NeoPixel library, we tell it how many pixels, and which pin to use to send signals.
// Note that for older NeoPixel strips you might need to change the third parameter--see the strandtest
// example for more information on possible values.
Adafruit_NeoPixel pixels = Adafruit_NeoPixel(NUMPIXELS, PIN, NEO_GRB + NEO_KHZ800);

int brightnessG = 0;
int brightnessB = 0;
int brightnessR = 0;

void setup() {

  pixels.begin(); // This initializes the NeoPixel library.
}

void loop() {
// Convertis les valeurs lues par le potentiomètre (de 0 à 1020) en valeurs de luminosité (de 0 à 255)
  brightnessG = analogRead(A0)/4;
  brightnessB = analogRead(A1)/4;
  brightnessR = analogRead(A2)/4;

  // For a set of NeoPixels the first NeoPixel is 0, second is 1, all the way up to the count of pixels minus one.

  for(int i=0;i<NUMPIXELS;i++){

    // pixels.Color takes RGB values, from 0,0,0 up to 255,255,255
    pixels.setPixelColor(i, pixels.Color(brightnessR,brightnessG, brightnessB)); // Moderately bright green color.

  }
    pixels.show(); // This sends the updated pixel color to the hardware.

}
