//Partie déclarative concernant la temperature en l'humidité




#include <DHT.h>
#include <DHT_U.h>

#include <Adafruit_NeoPixel.h>

#include <LiquidCrystal.h>
#include <Keypad.h>

#define DHTPIN 2     // what pin we're connected to
#define DHTTYPE DHT22   // DHT 22  (AM2302)
DHT dht(DHTPIN, DHTTYPE);


//Insertion de la variable delay_temperature, celle-ci sera utile pour utiliser la fonction millis à la place de la fonction delay qui permettra de ne pas mettre le programme en "pause"
long int delay_temperature;
int periode_echantillonnage = 3; // en seconde, periode entre chaque mesure de temperature-humidite



//Valeurs dÃ©claratives concernant la partie en contact avec l'air déjà humidifiÃ©
float temp_mes;
float temp_mes_preced;
float temp_voulue = 24 ;
int module_peltier_chaud_air = 3 ;
int module_peltier_froid_air = 4 ;

//kp_temp,ki_temp et kd_temp sont des coeficient utilisÃ© dans la fonction PID pour contrÃ´ler la chauffe du peltier en contact avec l'air humidifiÃ©
float Kp_temp = 1;
float Ki_temp = 1;
float Kd_temp = 5;
float ecart_temp;
float ecart_temp_preced;
int coeficient_temp;
float integral_temp;
float derivee_temp;





// Valeurs dÃ©clarative concernant la partie en contact avec le bol d'eau
int humidite_mes;
int humidite_mes_preced;
float humidite_voulue = 80;
int module_peltier_chaud_eau = 5;
int module_peltier_froid_eau = 6;

//kp_humidite, ki_humidite et kd_humidite sont des coeficient utilisÃ© dans la fonction PID pour contrÃ´ler la chauffe du peltier du bol d'eau
float Kp_humidite = 0.1;
float Ki_humidite = 1;
float Kd_humidite = 5;
float ecart_humidite;
float ecart_humidite_preced;
int coeficient_humidite;
float integral_humidite;
float derivee_humidite;






//Partie déclarative concernant les led NeoPixel


// Which pin on the Arduino is connected to the NeoPixels?
// On a Trinket or Gemma we suggest changing this to 1
#define PIN            7

// How many NeoPixels are attached to the Arduino?
#define NUMPIXELS      16

// When we setup the NeoPixel library, we tell it how many pixels, and which pin to use to send signals.
// Note that for older NeoPixel strips you might need to change the third parameter--see the strandtest
// example for more information on possible values.
Adafruit_NeoPixel pixels = Adafruit_NeoPixel(NUMPIXELS, PIN, NEO_GRB + NEO_KHZ800);

float brightnessG;
float brightnessB;
float brightnessR;
int brightnessG_pourcentage;
int brightnessB_pourcentage;
int brightnessR_pourcentage;






//Partie déclarative concernant l'affichage lcd et le KeyPad



const byte rows = 4; // Il y a 4 lignes sur le KeyPad
const byte cols = 3; // Il y a 3 colonnes sur le KeyPad

byte rowPins[rows] = {24, 26, 28, 30}; // Branchements des Pin des lignes du KeyPad
byte colPins[cols] = {32, 34, 36}; // Branchements des Pin des colonnes du KeyPad

// Définie la disposition des touches sur le KeyPad
char keys[rows][cols] = {
  {'1', '2', '3'},
  {'4', '5', '6'},
  {'7', '8', '9'},
  {'*', '0', '#'}
};

LiquidCrystal lcd(48, 46, 44, 42, 40, 38); // Branchements des Pin de l'écran LCD

//Crée le KeyPad
Keypad keypad = Keypad(makeKeymap(keys), rowPins, colPins, rows, cols);

int menu;


int intkey() {
  int key1;
  char key = keypad.getKey();
  if (key == NO_KEY)
    key1 = 12;
  if (key == '1')
    key1 = 1;
  if (key == '2')
    key1 = 2;
  if (key == '3')
    key1 = 3;
  if (key == '4')
    key1 = 4;
  if (key == '5')
    key1 = 5;
  if (key == '6')
    key1 = 6;
  if (key == '7')
    key1 = 7;
  if (key == '8')
    key1 = 8;
  if (key == '9')
    key1 = 9;
  if (key == '0')
    key1 = 0;
  if (key == '*')
    key1 = 10;
  if (key == '#')
    key1 = 11;
  return (key1);
}


int enter() {

  lcd.setCursor(12, 1);
  lcd.write(' ');
  lcd.setCursor(13, 1);
  lcd.write(' ');

  int a = 10;
  int b = 10;
  int val;

  while (a > 9)
    a = intkey();
  while (b > 9) {
    b = intkey ();
  }


  val = 10 * a + b;
  lcd.setCursor(12, 1);
  lcd.print(val);
  return (val);
}





// Fonction setup(), appelÃ©es au dÃ©marrage de la carte Arduino


void setup() {

  //Setup pour la température



  // Initialise la communication avec le PC
  Serial.begin(9600);
  dht.begin();
  //On dÃ©clare les branchements des modules peltiers comme sorti de l'arduino
  //Ces sorties contrÃ´leront le double pont en H ce qui alimentera ou non le peltier pour qu'il chauffe ou qu'il refroidisse
  pinMode(module_peltier_chaud_air, OUTPUT);
  pinMode(module_peltier_froid_air, OUTPUT);
  pinMode(module_peltier_chaud_eau, OUTPUT);
  pinMode(module_peltier_froid_eau, OUTPUT);



  //Setup pour les led NeoPixel

  pixels.begin(); // This initializes the NeoPixel library.

  lcd.clear();
  lcd.begin(16, 2);
  lcd.setCursor(0, 0);
  lcd.print("Choisir un menu");

  delay_temperature = millis();
}// Fin VoidSetup



//Début VoidParam, fonction qui va être appelée quand l'utilisateur voudra modifier temp_voulue ou humidite_voulue

void param(int menu) {

  if (menu == 1)
  {
    temp_voulue = enter();
    lcd.setCursor(14, 1);
    lcd.print("*C");
  }
  if (menu == 2)
  {
    humidite_voulue = enter();
    lcd.setCursor(14, 1);
    lcd.print("%");
  }

}// fin void param










// Fonction loop(), appelÃ©es continuellement en boucle tant que la carte Arduino est alimentÃ©e


void loop() {

  //Boucle concernant la température

  if ((millis() - delay_temperature) > periode_echantillonnage * 1000) {
    //La lecture de la tempÃ©rature ou de l'humidite peut prendre jusqu'Ã  250 millisecondes


    //Integre dans les variables humidite_mes et temp_mes les donnÃ©es issues du capteur
    humidite_mes = dht.readHumidity();
    temp_mes = dht.readTemperature();



    // VÃ©rifie si la lecture de la tempÃ©rature et de l'humidite est bien effectuÃ©e
    if (isnan(humidite_mes) || isnan(temp_mes)) {
      Serial.println("Failed to read from DHT sensor!");
      return;
    }


    //Début de la boucle température
    //Fonctionnement du PID, pour en savoir plus pour le PID : https://en.wikipedia.org/wiki/PID_controller
    ecart_temp = temp_voulue - temp_mes;
    integral_temp = integral_temp + ecart_temp * periode_echantillonnage;
    derivee_temp = (ecart_temp - ecart_temp_preced) / periode_echantillonnage;
    coeficient_temp = (Kp_temp * ecart_temp + Ki_temp * integral_temp + Kd_temp * derivee_temp);
    if (coeficient_temp > 255 ) coeficient_temp = 255; // coeficient_temp va être une sortie "pseudo-analogique", PWM. Le rapport cyclique du PWM prend des valeursde 0 à 100%  en 10 bits sela donne donc de 0 a 255
    ecart_temp_preced = ecart_temp;


    //Verifie la tempÃ©rature mesurÃ©e par rapport Ã  la tempÃ©rature dÃ©sirÃ©e
    if (ecart_temp > 0) {
      analogWrite (module_peltier_chaud_air , coeficient_temp);// utilisation du PWM pour controler les modules Peltier avec le pont en H
      digitalWrite (module_peltier_froid_air , LOW);
    }
    else {
      int coeficient_temp_negatif = -coeficient_temp;
      if (coeficient_temp_negatif > 255 ) coeficient_temp_negatif = 255;
      digitalWrite (module_peltier_chaud_air , LOW);
      analogWrite (module_peltier_froid_air , coeficient_temp_negatif);// utilisation du PWM pour controler les modules Peltier avec le pont en H
    }
    //Fin de la boucle température


    //Début de la boucle humiditié
    //Fonctionnement du PID, pour en savoir plus pour le PID : https://en.wikipedia.org/wiki/PID_controller
    ecart_humidite = humidite_voulue - humidite_mes;
    integral_humidite = integral_humidite + ecart_humidite * periode_echantillonnage;
    derivee_humidite = (ecart_humidite - ecart_humidite_preced) / periode_echantillonnage;
    coeficient_humidite = (Kp_humidite * ecart_humidite + Ki_humidite * integral_humidite + Kd_humidite * derivee_humidite);
    if (coeficient_humidite > 255 ) coeficient_humidite = 255 ;// coeficient_humidite va être une sortie "pseudo-analogique", PWM. Le rapport cyclique du PWM prend des valeursde 0 à 100%  en 10 bits sela donne donc de 0 a 255
    ecart_humidite_preced = ecart_humidite;


    //Verifie l'humiditÃ©e mesurÃ©e par rapport Ã  l'humiditÃ©e dÃ©sirÃ©e
    if (ecart_humidite > 0) {
      analogWrite (module_peltier_chaud_eau , coeficient_humidite); // utilisation du PWM pour controler les modules Peltier avec le pont en H
      digitalWrite (module_peltier_froid_eau , LOW);

    }
    else {
      int coeficient_humidite_negatif = -coeficient_humidite;      
      if (coeficient_humidite_negatif > 255 ) coeficient_humidite_negatif = 255 ;
      analogWrite (module_peltier_froid_eau , coeficient_humidite_negatif);// utilisation du PWM pour controler les modules Peltier avec le pont en H
      digitalWrite (module_peltier_chaud_eau , LOW);
    }
    // Fin de la boucle humidité

    delay_temperature = millis();
  }


  //Début de la boucle concernant les led NeoPixel

  // Convertis les valeurs lues par le potentiomètre (de 0 à 1023) en valeurs de luminosité (de 0 à 255)
  brightnessG = analogRead(A0) / 4;
  brightnessB = analogRead(A1) / 4;
  brightnessR = analogRead(A2) / 4;

  brightnessG_pourcentage = brightnessG / 255 * 100;
  brightnessB_pourcentage = brightnessB / 255 * 100;
  brightnessR_pourcentage = brightnessR / 255 * 100;



  // For a set of NeoPixels the first NeoPixel is 0, second is 1, all the way up to the count of pixels minus one.

  for (int i = 0; i < NUMPIXELS; i++) {

    // pixels.Color takes RGB values, from 0,0,0 up to 255,255,255
    pixels.setPixelColor(i, pixels.Color(brightnessR, brightnessG, brightnessB)); // Moderately bright green color.

  }
  pixels.show(); // This sends the updated pixel color to the hardware.

  //Fin de la boucle concernant les NéoPixel

  //Fonction d'affichage des valeurs mesurés




  //Début de la partie voidloop concernant l'affichage et les commandes keyboard
  int key = intkey ();
  if (menu == 0)
  {

    //Menu Température
    if (key == 1)
    {
      lcd.clear();
      menu = 1;
      lcd.setCursor(0, 0);
      lcd.print("Temperature");
      lcd.setCursor(12, 1);
      lcd.print(temp_voulue);
      lcd.setCursor(14, 1);
      lcd.print("*C");
      lcd.setCursor(0, 1);
      lcd.print(temp_mes);
      lcd.setCursor(4, 1);
      lcd.print("*C");
    }

    //Menu Humidité
    if (key == 2){
      lcd.clear();
      menu = 2;
      lcd.setCursor(0, 0);
      lcd.print("Humidite");
      lcd.setCursor(12, 0);
      lcd.print(humidite_mes);
      lcd.setCursor(14, 0);
      lcd.print("%");
      lcd.setCursor(4, 1);
      lcd.print("voulue:");
      lcd.setCursor(12,1);
      lcd.print(humidite_voulue);
      lcd.setCursor(14, 1);
      lcd.print("%_");
     
    }
    
  if (key == 3){
      lcd.clear();
      lcd.setCursor(0, 0);
      lcd.print("Luminosite (%)");

      
      lcd.setCursor(0, 1);
      lcd.print(brightnessR_pourcentage);
      lcd.setCursor(3, 1);
      lcd.print("R");
      
      lcd.setCursor(6, 1);
      lcd.print(brightnessG_pourcentage);
      lcd.setCursor(9, 1);
      lcd.print("G");    

      
      lcd.setCursor(12, 1);
      lcd.print(brightnessB_pourcentage);
      lcd.setCursor(15, 1);
      lcd.print("B");
    }
  }
  if (key == 10)
    param(menu);

  if (key == 11) {
    setup();
    menu = 0;
  }
  // Fin des commandes concernant la boucle void de l'écran lcd et de du keypad



}//Fin du programme

