// constantes
const int IRDetectorPin = 2; // pin du détecteur IR
const int ledPin = 13;       // pin de la LED
 
// Variables
int ledState = LOW;      // led éteinte
int IRState;             // état courant du détecteur IR
int lastIRState = LOW;   // etat precedant du détecteur IR (pour détecter un changement)
 
// variable de temps en millisecondes
long lastDebounceTime = 0;   // derniere fois que le détecteur a changé
long debounceDelay = 1;   // délai pour valider un changement (la roue tourne rapidement)

 
void setup() {
  pinMode(IRDetectorPin, INPUT);
  pinMode(ledPin, OUTPUT);
 
  // initialisation de la led
  digitalWrite(ledPin, ledState);
}
 

void loop() {
  // lecture du detecteur IR dans une variable locale
  int reading = digitalRead(IRDetectorPin);
 
  // si le faisceau est coupé (reading == HIGH ou 1)
  //on attend pour être sûr que ça n'est pas un parasite
 
  // le detecteur a-t-il changé ?
  if (reading != lastIRState) {
    // on déclenche le timer
    lastDebounceTime = millis();
  }
 
  if ((millis() - lastDebounceTime) > debounceDelay) {
    // si le délai est atteint, le changement est validé
 
    // changement validé
    if (reading != IRState) {
      IRState = reading;
      // on répercute le changement sur l'état led
      ledState = IRState;
      digitalWrite(ledPin, ledState);
 
      // si IRState est HIGH, il s'agit de la partie opaque
      //de la roue
 
      // si IRSate est LOW, il s'agit de la partie vide
      //de la roue
      }
    }
   // on sauve l'état du detecteur pour le tour suivant
  lastIRState = reading;
  /* ainsi, le moindre changement avant la fin du delai debounceDelay
   va reinitialiser ce delai */
 
}
