import matplotlib.pyplot as plt
import numpy as np
import serial

x_size = None
y_size = None
temperatures = None
amb_temp = 0.0

running = True

#f = open('test.txt', 'r')

ser = serial.Serial(port='/dev/ttyUSB0', baudrate=9600, parity=serial.PARITY_ODD, stopbits=serial.STOPBITS_TWO, bytesize=serial.SEVENBITS)

if not ser.is_open:
    ser.open()

ser.flushInput()
ser.flushOutput()

while running:
    # Read data from the input
    #data = input().split()

    # Read data from a file
    #data = f.readline().split()

    line = ser.readline().decode("utf-8")
    if len(line.split()) > 0:
        data = line.split()
        print(data)

    if data[0] == 'START':
        # START x_size y_size

        x_size = int(data[1])
        y_size = int(data[2])

        # Generate a table with all zeros
        temperatures = np.zeros((y_size, x_size))

        # Generate a table with random temp between -10 and +50 Celsius degrees
        #temperatures = np.random.randint(-10, 50, (y_size, x_size))

    elif data[0] == 'TOBJ':
        # TOBJ x y temp

        x = int(data[1])
        y = int(data[2])
        temp = float(data[3])

        temperatures[y][x] = temp

    elif data[0] == 'TAMB': 
        # TAMB temp

        ambient_temp = float(data[1])

    elif data[0] == 'STOP':
        # STOP

        running = False

        print(temperatures)

        #min_temp = temperatures.min()
        #max_temp = temperatures.max()

        plt.imshow(temperatures, cmap='plasma')
        plt.colorbar()
        plt.xlabel('Ambient temperature : {} °C'.format(amb_temp))
        plt.show()
