//= Paramètres fixes
longueur_telephone = 145;
largeur_telephone = 70;
epaisseur_telephone = 10;

angle_voulu = 20;
fn = 100;

//= Paramètres à ajuster

// Surélévation du code par rapport au sol (hauteur entre le fond du trou et le sol)
surelevation_cone = 5;
// Décalage en arrière du support pour réduire son diamètre
decalage_arriere = 10;
// Surépaisseur du cone (qui s'ajoute au rayon, donc x2) nécessaire car on a surélevé le cone
surepaisseur_cone = 4;
// Hauteur du renfort qui bloque le bas du téléphone et l'empêche de glisser
hauteur_renfort = 6;

//= Calcul des angles et des longueurs

// Longueur minimale du support pour que le support ne bascule pas (on considère que le centre de gravité du téléphone est au centre du volume)
// La moitié de la longueur du téléphone, multiplié par un coefficient de sécurité
longueur_necessaire = (longueur_telephone/2)*1.1;

// Calcul du triangle 1 (regarder le schéma correspondant)
T1_hypothenuse = longueur_necessaire;
T1_oppose = epaisseur_telephone/2;
T1_angle = asin(T1_oppose/T1_hypothenuse);
T1_adjacent = T1_hypothenuse*cos(T1_angle);

// Calcul du triangle 2 (regarder le schéma correspondant)
T2_hypothenuse = T1_adjacent;
T2_angle = angle_voulu - T1_angle; // le total des angles des deux triangles doit faire l'angle voulu
T2_adjacent = T2_hypothenuse*cos(T2_angle);
T2_oppose = T2_hypothenuse*sin(T2_angle);

//= Modélisation du support

// Coté du cube utilisé pour créer le trou
cote_cube = 150;
largeur_trou = T1_oppose + epaisseur_telephone;
module Trou() {
    difference() {
        cube(cote_cube);
        translate([largeur_trou, 0, 0]) {
            cube([cote_cube-largeur_trou, cote_cube, hauteur_renfort]);
        }
    }
}

hauteur_cone = T2_adjacent + surelevation_cone;
rayon_cone = surepaisseur_cone-decalage_arriere + largeur_trou + T2_oppose;
echo("Diamètre du support : ", 2*rayon_cone);
echo("Hauteur du support : ", hauteur_cone);

module Cone(r1) {
    cylinder(hauteur_cone, r1=r1, r2=decalage_arriere, $fn=fn);
}

difference() {
    Cone(r1=rayon_cone);
    Cone(r1=rayon_cone-surepaisseur_cone);
    translate([T2_oppose-decalage_arriere, -cote_cube/2, surelevation_cone]) {
        rotate([0, -T2_angle, 0]) Trou();
    }
}

module VraiTelephone() {
    cube([epaisseur_telephone, largeur_telephone, longueur_telephone]);
}
// Affichage en transparence du vrai téléphone pour vérifier que le support est bon
// ATTENTION, il faut commenter cette ligne avant d'imprimer la pièce !
//translate([longueur_necessaire*sin(angle_voulu)-decalage_arriere, -largeur_telephone/2, surelevation_cone]) rotate([0, -angle_voulu, 0]) VraiTelephone();
