#define led 8
#define trigPin0 18
#define echoPin0 19
#define trigPin1 14
#define echoPin1 15
#define DIST_MAX 15
#define True 1
#define False 0

short counter = 0;
unsigned short reset = 0;
bool wait0 = False;
bool wait1 = False;

void setup()
{
  pinMode(trigPin0, OUTPUT);
  pinMode(echoPin0, INPUT);
  pinMode(trigPin1, OUTPUT);
  pinMode(echoPin1, INPUT);
  pinMode(led, OUTPUT);
  Serial.begin(9600);
  Serial.print("ok\n");

}

bool ping(bool no) {
  int trig_pin = no ? trigPin1 : trigPin0;
  int echo_pin = no ? echoPin1 : echoPin0;
  long duration, distance;
  digitalWrite(trig_pin, LOW);
  delayMicroseconds(2);
  digitalWrite(trig_pin, HIGH);
  delayMicroseconds(10);
  digitalWrite(trig_pin, LOW);
  duration = pulseIn(echo_pin, HIGH);
  distance = (duration / 2) / 29.1;
  return distance < DIST_MAX;
}

void loop()
{
  if (ping(0)) {
    if (wait0) {
      counter ++;
      wait0 = False;
    }
    else
      wait1 = True;
  }
  if (ping(1)) {
    if (wait1) {
      counter--;
      wait1 = False;
    }
    else
      wait0 = True;
  }
  if (wait1 || wait0) {
    if (reset > 4) {
      wait1 = False;
      wait0 = False;
      reset = 0;
    }
    else
      reset++;
  }
  if (counter > 10)
    digitalWrite(led, HIGH);
  else
    digitalWrite(led, LOW);
  Serial.print("counter : ");
  Serial.print(counter);
  Serial.print(" wait 1 : ");
  Serial.print(wait1);
  Serial.print(" wait 0 : ");
  Serial.println(wait0);
  delay(300);
}
